from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask
import sandbox.projects.common.constants as consts
import sandbox.projects.common.build.parameters as build_params

import sandbox.projects.collections.resources as resources


class CollectionsBuildMiddlesearchBinaries(BaseMediaBuildTask):
    """
       Binaries and configs for RTY server of boards search
    """

    type = 'COLLECTIONS_BUILD_MIDDLESEARCH_BINARIES'

    def initCtx(self):
        self.ctx[consts.BUILD_BUNDLE_KEY] = False
        self.ctx[build_params.StripBinaries.name] = True

    def get_binaries(self):
        return (
            resources.CollectionsMiddlesearchExecutable
        )

    def get_configs(self):
        return (
        )


__Task__ = CollectionsBuildMiddlesearchBinaries
