import logging

from sandbox import sdk2
import sandbox.sandboxsdk.copy as sdk_copy

import sandbox.projects.collections.resources as resources


SHARD_FILES = {
                "dssm_q2t_doc.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/dssm_q2t_doc.cfg",
                "dssm_q2t_doc.net": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/dssm_q2t_doc.net",
                "dssm_q2t_query.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/dssm_q2t_query.cfg",
                "dssm_q2t_query.net": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/dssm_q2t_query.net",
                "dssm_q2t_trigrams_dict.tsv": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/dssm_q2t_trigrams_dict.tsv",
                "dssm_q2t_words_dict.tsv": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/dssm_q2t_words_dict.tsv",
                "i2t_ver7_fall2016_clickbase_char_trigrams_dict_uniq.tsv": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/i2t_ver7_fall2016_clickbase_char_trigrams_dict_uniq.tsv",
                "i2t_ver7_fall2016_clickbase_words_bigrams_dict_uniq.tsv": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/i2t_ver7_fall2016_clickbase_words_bigrams_dict_uniq.tsv",
                "i2t_ver7_fall2016_clickbase_words_dict_uniq.tsv": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/i2t_ver7_fall2016_clickbase_words_dict_uniq.tsv",
                "i2t_ver9_txt_prod.cfg": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/i2t_ver9_txt_prod.cfg",
                "i2t_ver9_txt_prod.net": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/collections/meta/i2t_ver9_txt_prod.net",
                "t2t_doc.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/t2t_doc.dssm",
                "t2t_query.dssm": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia_tests_data/images/robot/index/config/t2t_query.dssm"
}


class CollectionsBuildMiddlesearchShard(sdk2.Task):
    """
        Generate configs and data for middlesearch rearrage rules
    """
    class Requirements(sdk2.Task.Requirements):
        pass

    def on_execute(self):
        logging.info('Get resource object')
        resource = resources.CollectionsMiddlesearchShard(self, "mmeta configs", "mmeta_shard")
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.mkdir()

        for filename, src_path in SHARD_FILES.iteritems():
            sdk_copy.RemoteCopy(src_path, str(resource_data.path.joinpath(filename)),
                                       log_dir=self.log_path())(timeout=sdk_copy.RemoteCopy.DEFAULT_TIMEOUT)
