# -*- coding: utf-8 -*-

import platform

import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.process as sdk_process
import sandbox.sandboxsdk.parameters as sdk_parameters
import sandbox.projects.resource_types


class BuildPdbPHANTOMJSPackage(sdk_task.BuildForAllMode):
    """
    Build PHANTOMJS binary package of specified version
    """

    class Version(sdk_parameters.SandboxStringParameter):
        name = "version"
        description = "PHANTOMJS version"
        default_value = "2.1.1"

    input_parameters = [Version]
    type = "BUILD_YASAP_PDB_PHANTOMJS_PACKAGE"

    resource_type = str(sandbox.projects.resource_types.YASAP_PDB_PHANTOMJS_PACKAGE)

    @classmethod
    def required_resources(cls):
        return [(cls.resource_type, "PHANTOMJS package for {plat}".format(plat=platform.platform()))]

    def on_execute(self):
        version = self.ctx[self.Version.name]
        package_url = "https://bitbucket.org/ariya/phantomjs/downloads/phantomjs-{}-linux-x86_64.tar.bz2".format(version)
        archive = "phantomjs.tar.bz2"

        with self.current_action("Download archive '{}'".format(package_url)):
            sdk_process.run_process(
                ["curl", '-L', package_url, "-o", archive],
                log_prefix="download"
            )

        with self.current_action("Extracting archive to '{}'".format(archive)):
            sdk_process.run_process(
                ["tar", "xf", archive, "--strip-components=1"],
                log_prefix="extract"
            )

        # Create resource
        self.create_resource(
            description='YASAP_PDB_PHANTOMJS_PACKAGE',
            resource_path="bin/phantomjs",
            resource_type=sandbox.projects.resource_types.YASAP_PDB_PHANTOMJS_PACKAGE,
            arch='any'
        )


__Task__ = BuildPdbPHANTOMJSPackage
