# -*- coding: utf-8 -*-

import logging

import sandbox.common.types.misc as ctm

from sandbox import sdk2
from sandbox.projects.collections.mixins import NannyMixin
from sandbox.projects.sandbox_ci import SANDBOX_CI_LXC_IMAGE


class CollectionsRemoveNannyServices(sdk2.Task, NannyMixin):
    """
        Collections remove services
    """
    class Requirements(sdk2.Requirements):
        dns = ctm.DnsType.LOCAL

    class Parameters(sdk2.Parameters):
        kill_timeout = 3600
        _container = sdk2.parameters.Container(
            'Build environment',
            resource_type=SANDBOX_CI_LXC_IMAGE,
            platform='linux_ubuntu_16.04_xenial',  # necessary for correct default resource searching
            required=True,
        )

        with sdk2.parameters.Group('Nanny configuration params') as nanny_params:
            service_prefix = sdk2.parameters.String(
                'Service prefix',
                required=True,
                default='pdb_nodejs_test_feature_pr',
                description='Префикс нового или уже существующего сервиса {prefix}{pr_num}.',
            )
            pr_numbers = sdk2.parameters.List(
                'Closed pull request numbers',
                required=True,
                default=[],
                description=' Список пулл-реквестов, сервисы (стенды) которых нужно удалить.',
            )

    def on_execute(self):
        service_ids = []

        if not self.Parameters.pr_numbers:
            raise Exception('Nothing to remove, pr_numbers are empty.')

        for pr_number in self.Parameters.pr_numbers:
            service_id = '{prefix}{num}'.format(
                prefix=self.Parameters.service_prefix,
                num=pr_number
            )
            service_ids.append(service_id)

        logging.info('trying to remove service configurations for {services}'.format(services=service_ids))

        # для того, чтобы удалить сервисы нужно сначала удалить все snapshot-ы
        self.remove_snapshots(service_ids)
        # удаляем сервисы
        self.remove_services(service_ids)
