# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process


class CollectionsDeployNannyService(CollectionsFrontendBase):
    """
        Collections deploy nanny service
    """
    class Parameters(CollectionsFrontendBase.Parameters):
        with CollectionsFrontendBase.Parameters.build() as build:
            production = sdk2.parameters.Bool('Production', default=True)
            testing = sdk2.parameters.Bool('Testing', default=True)

    class Requirements(CollectionsFrontendBase.Requirements):
        ram = 2 * 1024
        cores = 2

    def on_execute(self):
        context = '[Collections CI] Deploy'

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules()

            environment = self.environment

            if self.Parameters.testing:
                run_process(
                    [
                        self.node_bin,
                        self.npm_bin,
                        'run',
                        'ci:deploy'
                    ],
                    work_dir=self.src_root,
                    log_prefix='deploy',
                    environment=environment
                )
            elif self.Parameters.production:
                run_process(
                    [
                        self.node_bin,
                        self.npm_bin,
                        'run',
                        'ci:deploy:release'
                    ],
                    work_dir=self.src_root,
                    log_prefix='deploy',
                    environment=environment
                )

        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise

        self.report_success_to_github(context)


__TASK__ = CollectionsDeployNannyService
