# -*- coding: utf-8 -*-

import json

from sandbox.projects.sandbox_ci.utils.request import send_request

GENCFG_API = 'http://api.gencfg.yandex-team.ru'


class GenCfgApi(object):
    def __init__(self, token, url=GENCFG_API):
        self._url = url
        self._token = token
        self._headers = {
            'Authorization': 'OAuth {token}'.format(token=self._token),
        }

    def get_full_url(self, path):
        """
        Возвращает полный URL-адрес, используя базовый адрес и путь.

        :param path: Запрашиваемый путь
        :type path: str
        :rtype: str
        """
        return '{}/{}'.format(self._url, path)

    def fetch_host(self, group, tag='unstable'):
        host_query_path = '{tag}/searcherlookup/groups/{group}/instances'.format(
            tag=tag,
            group=group,
        )
        url = self.get_full_url(host_query_path)
        res = send_request('get', url, headers=self._headers, verify=False)

        assert res.status_code == 200, {'status_code': res.status_code, 'text': res.text}

        return json.loads(res.text)

    def fetch_group(self, group, tag='unstable'):
        card_query_path = '{tag}/groups/{group}/card'.format(
            tag=tag,
            group=group,
        )
        url = self.get_full_url(card_query_path)
        res = send_request('get', url, headers=self._headers, verify=False)

        assert res.status_code == 200, {'status_code': res.status_code, 'text': res.text}

        return json.loads(res.text)

    def fetch_tags(self):
        url = self.get_full_url('trunk/tags')
        res = send_request('get', url, headers=self._headers, verify=False)

        assert res.status_code == 200, {'status_code': res.status_code, 'text': res.text}

        return json.loads(res.text)

    def get_first_tag(self):
        tags = self.fetch_tags()

        return tags.get('tags', [])[0] if tags else None
