# -*- coding: utf-8 -*-

import logging
from sandbox import sdk2
import requests
from datetime import date, timedelta


class CollectionsExpNotifier(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        # common parameters
        kill_timeout = 3600

        # custom parameters
        chat_id = sdk2.parameters.String("chat_id", required=True)
        mention_usernames = sdk2.parameters.String("mention_usernames", required=True)
        queue_id = sdk2.parameters.String("queue_id", required=True)
        dimension_ids = sdk2.parameters.List("dimension_ids", required=False)

    def format_exp_info(self, ab_task):
            output = ('*Запущен* '+ u'\U00002705' + ' ' if ab_task['history_state'] == 'RUNNING' else '*Закончен* ' + u'\U0001F44D' + ' ')
            output += '[' + ab_task['title'] + '](https://ab.yandex-team.ru/task/'+ab_task['ticket']+') '
            output +=  'на ' + ('внутреннюю сеть ' if ab_task['staff_only'] else '*внешнюю сеть* ' +\
                    str(ab_task['percent_total']) + '% (контроль ' + str(ab_task['percent']) + '%)' ) + '\n\n'

            return output

    def on_execute(self):

        bot_token = sdk2.Vault.data("telegram_roboklim")
        logging.info("Hello, World!" + bot_token + self.Parameters.queue_id)

        url = "https://ab.yandex-team.ru/api/task/history?queue_id=" + str(self.Parameters.queue_id) + \
        "&datestart=" + (date.today() - timedelta(1)).strftime('%Y%m%d') + \
        "&dateend=" + (date.today() - timedelta(1)).strftime('%Y%m%d') + "&format=json"
        logging.info(url)

        response = requests.get(url, verify=False)
        history = response.json()

        data = []

        for event in history:
            if 'state' in event['changes'] and event['changes']['state'][1] in ['RUNNING', 'STOPPED']:
                task_details_url = 'https://ab.yandex-team.ru/api/task/' + event['ticket']
                response = requests.get(task_details_url, verify=False)

                task_details = response.json()

                task_details['history_state'] = event['changes']['state'][1]

                if len(self.Parameters.dimension_ids) == 0 or str(task_details['dimension_id']) in self.Parameters.dimension_ids:
                    data.append(task_details)

        if len(data) > 0:

            message_text = ''

            for ab_task in data:
                message_text += self.format_exp_info(ab_task)

            message_text += 'cc ' + self.Parameters.mention_usernames

            payload = {'chat_id': self.Parameters.chat_id, 'text': message_text, 'parse_mode': 'markdown'}
            requests.post("https://api.telegram.org/bot" + bot_token + "/sendMessage", data=payload)

__TASK__ = CollectionsExpNotifier
