# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.sandboxsdk.process import run_process


class CollectionsFrontendAssessorsRun(CollectionsFrontendBase):
    """
        Collections assessors run
    """
    class Parameters(CollectionsFrontendBase.Parameters):
        with sdk2.parameters.Group('Features') as features:
            project = sdk2.parameters.String('project', default='collections-dev')
            version = sdk2.parameters.String('version', default='')
            preset = sdk2.parameters.String('preset', default='')
            dry_run = sdk2.parameters.Bool('dry_run', default=False)

    def get_secret(self, name, prefix='assessors'):
        return sdk2.Vault.data('YASAP', prefix + '_' + name)

    def get_config_path(self):
        return './assessors/release-collections-' + str(self.Parameters.preset) + '.json'

    def on_execute(self):
        self.prepare_working_copy()
        self.install_modules()

        env = self.environment

        env['SANDBOX_AUTH_TOKEN'] = self.get_secret('sandbox_auth_token', 'palmsync')
        env['palmsync_testpalmToken'] = self.get_secret('testpalm_token', 'palmsync')
        env['assessors_testpalmToken'] = self.get_secret('testpalm_token')
        env['assessors_testpalmOauthToken'] = self.get_secret('testpalm_oauth_token')

        run_process(
            [
                self.node_bin,
                self.npm_bin,
                'run',
                'assessors:run',
                '--',
                '--project', str(self.Parameters.project),
                '--version', str(self.Parameters.version),
                '--config', self.get_config_path(),
                '--dry-run' if self.Parameters.dry_run else '--run'
            ],
            work_dir=self.src_root,
            log_prefix='assessors_run',
            environment=env
        )


__TASK__ = CollectionsFrontendAssessorsRun
