from sandbox import sdk2
from sandbox.projects.collections.resources import CollectionsResourceBase


class CollectionsFrontendResourceBase(CollectionsResourceBase):
    releasable = True
    auto_backup = True


class CollectionsFrontendResourcePackage(CollectionsFrontendResourceBase):
    """
        Collections frontend package
    """


class CollectionsFrontendResourceTestPackage(CollectionsFrontendResourceBase):
    """
        Collections test frontend package
    """


class CollectionsFrontendResourceStatic(CollectionsFrontendResourceBase):
    """
        Collections frontend static
    """
    env = sdk2.parameters.String('Environment')
    version = sdk2.parameters.String('Version')


class CollectionsFrontendResourceChrome(CollectionsFrontendResourceBase):
    """
        Collections chrome extension
    """


class CollectionsFrontendResourceSize(CollectionsFrontendResourceBase):
    """
        Collections frontend size
    """
    env = sdk2.parameters.String('Environment')
    target = sdk2.parameters.String('Target')


class CollectionsNodeBinary(CollectionsFrontendResourceBase):
    """
        Node.js binary package
    """


class CollectionsFrontendResourceEslint(CollectionsFrontendResourceBase):
    """
        Eslint output
    """


class CollectionsFrontendResourceTrace(CollectionsFrontendResourceSize):
    """
        Trace output
    """


class CollectionsFrontendResourcePulse(CollectionsFrontendResourceBase):
    """
        Collections JSON pulse
    """
    stand = sdk2.parameters.String('Stand')


class CollectionsFrontendResourceGeminiReport(CollectionsFrontendResourceBase):
    """
        Collections Gemini report
    """
    platform = sdk2.parameters.String('Platform')
    commit = sdk2.parameters.String('Commit hash')


class CollectionsFrontendResourceE2EReport(CollectionsFrontendResourceBase):
    """
        Collections E2E report
    """
    preset = sdk2.parameters.String('Preset')
    commit = sdk2.parameters.String('Commit hash')


class CollectionsFrontendResourceLighthouse(CollectionsFrontendResourceBase):
    """
        Collections JSON lighthouse
    """
    target = sdk2.parameters.String('Target')


class CollectionsFrontendResourceBundleSizeJson(CollectionsFrontendResourceBase):
    """
        Collections JSON BundleSize
    """
    origin = sdk2.parameters.String('Origin')


class CollectionsFrontendCiArtifact(sdk2.Resource):
    """
    Bundle with typed artifact
    """
    auto_backup = True
    any_arch = True
    __default_attribute__ = sdk2.parameters.String
