# -*- coding: utf-8 -*-

import os
from sandbox import sdk2

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.projects.collections.CollectionsFrontendBase.resources import CollectionsFrontendResourceBundleSizeJson
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process


class CollectionsFrontendBundleSize(CollectionsFrontendBase):
    """
        Collections BundleSize
    """
    class Requirements(CollectionsFrontendBase.Requirements):
        ram = 2 * 1024
        cores = 2

    class Parameters(CollectionsFrontendBase.Parameters):
        with sdk2.parameters.Group('Features') as features:
            origin = sdk2.parameters.String('Origin', default='https://l7test.yandex.ru')

    def on_execute(self):
        context = '[Collections CI] Bundle Size'
        success = True

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules()

            environment = self.environment

            run_process(
                [
                    self.node_bin,
                    self.gulp_bin,
                    'bundle:size',
                    '--origin',
                    self.Parameters.origin
                ],
                work_dir=self.src_root,
                log_prefix='bundleSize',
                environment=environment
            )
        except SandboxSubprocessError:
            success = False

        footer_data_path = os.path.join(str(self.src_root), 'dist/web/bundle-size.html')
        if os.path.isfile(footer_data_path):
            report = open(footer_data_path, 'r')
            self.Context.footer += report.read()

        report_path = os.path.join(self.src_root, 'dist/web/bundle-size.json')
        if os.path.isfile(report_path):
            res = CollectionsFrontendResourceBundleSizeJson(
                self,
                'BundleSize report',
                report_path,
                origin=self.Parameters.origin,
            )

            report = sdk2.ResourceData(res)
            report.ready()

        if success:
            self.report_success_to_github(context)
        else:
            self.report_error_to_github(context)
            raise

__TASK__ = CollectionsFrontendBundleSize
