import os

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process


class CollectionsFrontendEslint(CollectionsFrontendBase):
    """
        Collections eslint
    """

    class Requirements(CollectionsFrontendBase.Requirements):
        ram = 2 * 1024
        cores = 2

    def on_execute(self):
        context = 'sandbox/eslint'

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules(production=True)

            run_process(
                [
                    self.node_bin,
                    self.npm_bin,
                    'install',
                    '--no-package-lock',
                    '--ignore-scripts',
                    'eslint',
                    'babel-eslint'
                ],
                work_dir=self.src_root,
                log_prefix='install_eslint'
            )

            run_process(
                [
                    self.node_bin,
                    self.eslint_bin,
                    '--ignore-path=.eslintignore',
                    './src'
                ],
                work_dir=self.src_root,
                log_prefix='eslint'
            )
        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise

        self.report_success_to_github(context)

    @property
    def eslint_bin(self):
        return os.path.join(self.src_root, 'node_modules/.bin/eslint')


__TASK__ = CollectionsFrontendEslint
