# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.misc as ctm

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.sandbox_ci import SANDBOX_CI_LXC_IMAGE


class CollectionsFrontendKarma(CollectionsFrontendBase):
    """
        Collections mocha tests
    """
    class Requirements(CollectionsFrontendBase.Requirements):
        dns = ctm.DnsType.LOCAL
        ram = 2 * 1024
        cores = 2

    class Parameters(CollectionsFrontendBase.Parameters):
        _container = sdk2.parameters.Container(
            'Build environment',
            resource_type=SANDBOX_CI_LXC_IMAGE,
            platform='linux_ubuntu_16.04_xenial',  # necessary for correct default resource searching
            required=True,
        )

        with sdk2.parameters.Group('Features') as features:
            platform = sdk2.parameters.String('Platform', default='mobile')

    def on_execute(self):
        type = self.Parameters.platform
        context = '[Collections CI] Karma: {}'.format(type)

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules()

            environment = self.environment
            environment['STOP_WATCH'] = 'true'

            run_process(
                [
                    self.node_bin,
                    self.gulp_bin,
                    'karma:{}'.format(type),
                    '--sync'
                ],
                work_dir=self.src_root,
                log_prefix='karma',
                environment=environment
            )
        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise

        self.report_success_to_github(context)


__TASK__ = CollectionsFrontendKarma
