import os

from sandbox import sdk2
from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.projects.collections.CollectionsFrontendBase.resources import CollectionsFrontendResourceLighthouse
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process
# from sandbox.projects.Lighthouse.base import LighthouseContainer

SCRIPT_URL = 'https://github.yandex-team.ru/gist/jakwuh/ac5788cd39827f1b57964fbadcf96ec3/raw/run.sh'


class CollectionsFrontendLighthouse(CollectionsFrontendBase):
    """
        Collections frontend lighthouse
    """

    class Parameters(CollectionsFrontendBase.Parameters):
        with sdk2.parameters.Group('Features') as features:
            urls = sdk2.parameters.String('URLs', multiline=True)

        _container = sdk2.parameters.Container(
            'Lighthouse environment',
            # type=LighthouseContainer,  # FIXME: invalid argument (SANDBOX-6404)
            default_value=274035956,  # https://sandbox.yandex-team.ru/resource/274035956/view
            required=True
        )

    @property
    def src_root(self):
        return os.path.abspath('')

    def on_execute(self):
        context = 'sandbox/lighthouse-audit'

        self.report_pending_to_github(context)
        self.prepare_node()

        run_process([
            'curl',
            '-L', SCRIPT_URL,
            '-o', 'run.sh'
        ],
            work_dir=self.src_root,
            log_prefix='curl'
        )

        environment = self.environment
        environment['URLS'] = str(self.Parameters.urls)

        try:
            run_process(
                ['bash', './run.sh'],
                log_prefix='run.sh',
                work_dir=self.src_root,
                environment=environment
            )

            self.report_success_to_github(context)

            target = self.pr_number

            if not target:
                target = 'master'

            report = sdk2.ResourceData(CollectionsFrontendResourceLighthouse(
                self,
                'Frontend lighthouse report',
                os.path.join(self.src_root, 'report.json'),
                target=target
            ))

            report.ready()
        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise
        finally:
            try:
                self.Context.footer = open(os.path.join(self.src_root, 'diff.html'), 'r').read()
            except IOError:
                print('Can\'t open {}'.format(os.path.join(self.src_root, 'diff.html')))


__TASK__ = CollectionsFrontendLighthouse
