# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process


class CollectionsFrontendMocha(CollectionsFrontendBase):
    """
        Collections mocha tests
    """
    class Requirements(CollectionsFrontendBase.Requirements):
        ram = 2 * 1024
        cores = 2

    class Parameters(CollectionsFrontendBase.Parameters):
        with sdk2.parameters.Group('Features') as features:
            platform = sdk2.parameters.String('Platform', default='mobile')

    def on_execute(self):
        platform = self.Parameters.platform
        context = '[Collections CI] Mocha: {}'.format(platform)

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules()

            environment = self.environment
            environment['STOP_WATCH'] = 'true'

            run_process(
                [
                    self.node_bin,
                    self.gulp_bin,
                    'mocha:{}'.format(platform),
                    '--sync'
                ],
                work_dir=self.src_root,
                log_prefix='mocha',
                environment=environment
            )
        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise

        self.report_success_to_github(context)


__TASK__ = CollectionsFrontendMocha
