# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process


class CollectionsFrontendPalmsync(CollectionsFrontendBase):
    """
        Collections palmsync
    """
    class Requirements(CollectionsFrontendBase.Requirements):
        ram = 2 * 1024
        cores = 2

    class Parameters(CollectionsFrontendBase.Parameters):
        with sdk2.parameters.Group('Features') as features:
            app_ver = sdk2.parameters.String('App Version', default='')
            app_base_url = sdk2.parameters.String('App Base Url', default='')

    def get_secret(self, name):
        return sdk2.Vault.data('YASAP', 'palmsync_' + name)

    def on_execute(self):
        context = '[Collections CI] Palmsync'

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules()

            env = self.environment

            env['STARTREK_TOKEN'] = sdk2.Vault.data('YASAP', 'startrek_token')
            env['SANDBOX_AUTH_TOKEN'] = self.get_secret('sandbox_auth_token')
            env['JING_OAUTH_TOKEN'] = self.get_secret('jing_oauth_token')
            env['palmsync_testpalmToken'] = self.get_secret('testpalm_token')
            env['palmsync_s3MdsAccessKeyId'] = self.get_secret('s3_mds_access_key_id')
            env['palmsync_s3MdsAccessSecretKey'] = self.get_secret('s3_mds_access_secret_key')

            if self.Parameters.app_ver:
                env['GITHUB_APP_VERSION'] = self.Parameters.app_ver

            if self.Parameters.app_base_url:
                env['COLLECTIONS_BASE_URL'] = self.Parameters.app_base_url

            run_process(
                [
                    self.node_bin,
                    self.npm_bin,
                    'run',
                    'palmsync:sync',
                ],
                work_dir=self.src_root,
                log_prefix='palmsync_sync',
                environment=env
            )

        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise

        self.report_success_to_github(context)


__TASK__ = CollectionsFrontendPalmsync
