import os

from sandbox import sdk2
from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.projects.collections.CollectionsFrontendBase.resources import CollectionsFrontendResourcePulse
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process


class CollectionsFrontendPulse(CollectionsFrontendBase):
    """
        Collections frontend pulse
    """

    class Parameters(CollectionsFrontendBase.Parameters):
        with sdk2.parameters.Group('Features') as features:
            stand = sdk2.parameters.String('Stand', default='https://l7test.yandex.ru')

    def on_execute(self):
        context = 'sandbox/pulse'

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules(production=True)

            environment = self.environment
            environment['ORIGIN'] = str(self.Parameters.stand)

            run_process(
                [
                    self.node_bin,
                    self.gulp_bin,
                    'pulse',
                    '--sync'
                ],
                work_dir=self.src_root,
                log_prefix='pulse',
                environment=environment
            )

            self.Context.footer = open(os.path.join(self.src_root, 'dist/pulse.html'), 'r').read()

            size = sdk2.ResourceData(CollectionsFrontendResourcePulse(
                self,
                'Frontend size',
                os.path.join(self.src_root, 'dist/pulse.json'),
                stand=self.Parameters.stand
            ))
            size.ready()
        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise

        self.report_success_to_github(context)


__TASK__ = CollectionsFrontendPulse
