# -*- coding: utf-8 -*-
import logging
from shutil import copyfile

from sandbox import sdk2
from sandbox.projects.collections.CollectionsFrontendBase import resources
from sandbox.projects.common.nanny import nanny

class CollectionsFrontendRelease(nanny.ReleaseToNannyTask2, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        resource_id = sdk2.parameters.String("resource_id", default="", multiline=False)

    def on_execute(self):
        # https://st.yandex-team.ru/DEVTOOLSSUPPORT-18815#627cdc30258b6141a294798d
        # скачать ресурс,
        # скопировать его содержимое в директорию задачи (чужие ресурсы скачиваются в отдельную директорию),
        # создать новый ресурс из этих данных.
        project_env='production'
        resource_id = self.Parameters.resource_id
        logging.info('[CollectionsFrontendRelease] download resource:' + resource_id)

        resource = sdk2.Resource[self.Parameters.resource_id]
        resource_data = sdk2.ResourceData(resource)
        path = resource_data.path

        logging.info('[CollectionsFrontendRelease] download resource to ')
        logging.info('[CollectionsFrontendRelease]Resource %d downloaded to %s', resource_id, path)

        package = sdk2.ResourceData(self.production_resource(
            self,
            '[{}] Frontend package'.format(project_env),
            'frontend-{}.tar.gz'.format(project_env)
        ))

        copyfile(str(resource_data.path), str(package.path))

        package.ready()

    @property
    def production_resource(self):
        return resources.CollectionsFrontendResourcePackage

    @property
    def testing_resource(self):
        return resources.CollectionsFrontendResourceTestPackage
