# -*- coding: utf-8 -*-

from sandbox.projects.collections.CollectionsFrontendBase.base import CollectionsFrontendBase
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process


class CollectionsFrontendTslint(CollectionsFrontendBase):
    """
        Collections tslint
    """
    class Requirements(CollectionsFrontendBase.Requirements):
        ram = 2 * 1024
        cores = 2

    def on_execute(self):
        context = '[Collections CI] TSLint'

        self.report_pending_to_github(context)

        try:
            self.prepare_working_copy()
            self.install_modules()

            environment = self.environment

            run_process(
                [
                    self.node_bin,
                    self.npm_bin,
                    'run',
                    'tslint'
                ],
                work_dir=self.src_root,
                log_prefix='tslint',
                environment=environment
            )
        except SandboxSubprocessError:
            self.report_error_to_github(context)
            raise

        self.report_success_to_github(context)

__TASK__ = CollectionsFrontendTslint
