import requests

from sandbox import sdk2

import sandbox.common.types.misc as ctm


class CollectionsMetrics(sdk2.Task):
    """
        Collections metrics
    """

    class Requirements(sdk2.Requirements):
        disk_space = 1200
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Parameters):
        url = sdk2.parameters.String('URL', default='https://pdb-admin.n.yandex-team.ru/collections/web-api/metrics')

    def on_execute(self):
        r = requests.get(str(self.Parameters.url))

        if r.status_code != 200:
            raise Exception('HTTP response code was {}'.format(r.status_code))
