import os

import requests

from sandbox import common
import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.projects.collections.CollectionsFrontendBase import resources
from sandbox.sandboxsdk.process import run_process


class CollectionsNode(sdk2.Task):
    """
        Collections node.js
    """

    class Requirements(sdk2.Requirements):
        disk_space = 1200
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Parameters):
        version = sdk2.parameters.String('Node.js version', default='6.10.2')

    def on_execute(self):
        version = self.Parameters.version

        name = 'node-v{}'.format(version)
        archive = name + '-linux-x64.tar.gz'
        sources = os.path.abspath(name)
        archive_path = os.path.abspath(archive)

        package_url = 'http://nodejs.org/dist/v{}/{}'.format(version, archive)

        r = requests.get(package_url, stream=True)
        with open(archive_path, 'wb') as f:
            for chunk in r.iter_content(chunk_size=4095):
                if chunk:
                    f.write(chunk)
                    f.flush()

        os.mkdir(sources, 0o755)

        run_process(
            ['tar', '-xf', archive_path, '--strip-components=1', '--directory', sources],
            log_prefix='extract'
        )

        dist = sdk2.ResourceData(resources.CollectionsNodeBinary(
            self, 'node.js (v{})'.format(self.Parameters.version), 'node.tar.gz'
        ))

        run_process(
            ['tar', '-zcvf', str(dist.path), '-C', sources, '.'],
            log_prefix='pack'
        )

        dist.ready()


__TASK__ = CollectionsNode
