# -*- coding: utf-8 -*-

from sandbox.projects.collections.resources import CollectionsDupsMongoSaver

from sandbox.sandboxsdk import environments
from sandbox.sdk2.helpers import subprocess as sp

from sandbox import common

import os
from sandbox import sdk2


'''
Save image dups in mongo.
'''


class CollectionsSaveDupsToMongo(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        yt_proxy = sdk2.parameters.String('YT proxy', required=True, default='banach')
        yt_token = sdk2.parameters.String('YT token vault', required=True)
        dups_dir = sdk2.parameters.String('YT dir with dups states', required=True)
        dups_state = sdk2.parameters.String('Dups state', required=True)
        mongo_uri = sdk2.parameters.String('Mongo uri vault', required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment("yandex-yt-yson-bindings-skynet"),
        )
        ram = 8 * 1024
        disk_space = 8 * 1024

    def on_execute(self):
        binary_resource = CollectionsDupsMongoSaver.find(attrs=dict(released='stable')).order(-sdk2.Resource.id).first()
        binary_path = str(sdk2.ResourceData(binary_resource).path)

        env = os.environ.copy()
        env["YT_TOKEN"] = sdk2.Vault.data(self.Parameters.yt_token)
        env["MONGO_PDB_CG"] = sdk2.Vault.data(self.Parameters.mongo_uri)

        with sdk2.helpers.ProcessLog(self, logger="mongo_saver") as pl:
            ret_code = sp.Popen(
                [
                    binary_path,
                    '--server', self.Parameters.yt_proxy,
                    '--dups_dir', self.Parameters.dups_dir,
                    '--timestamp', str(self.Parameters.dups_state),
                ],
                stdout=pl.stdout, stderr=sp.STDOUT, env=env
            ).wait()
            if ret_code != 0:
                raise common.errors.TaskFailure('mongo_saver run failed')
