import logging
import subprocess

from sandbox import sdk2
from sandbox.projects.common import utils
from sandbox.sandboxsdk.environments import PipEnvironment

from sandbox.projects.collections.resources import CollectionsExportBannedBoardsBinary


class CollectionsExportBannedBoards(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = (
            PipEnvironment('yandex-yt'),
            PipEnvironment('yandex-yt-yson-bindings-skynet'),
        )

    class Parameters(sdk2.Task.Parameters):
        logs_dir = sdk2.parameters.String('YT directory with logs')
        result_table = sdk2.parameters.String('YT directory for result table')

        yt_token_secret = sdk2.parameters.String('YT token secret')
        yt_proxy = sdk2.parameters.String('YT proxy (cluster)')

    def on_execute(self):
        tool_id = utils.get_and_check_last_released_resource_id(CollectionsExportBannedBoardsBinary)
        resource = sdk2.Resource[tool_id]
        tool_path = str(sdk2.ResourceData(resource).path)
        yt_token = sdk2.Vault.data(self.owner, self.Parameters.yt_token_secret)
        args = [
            tool_path,
            '--yt-proxy', self.Parameters.yt_proxy,
            '--logs-path', self.Parameters.logs_dir,
            '--output-table-path', self.Parameters.result_table
        ]
        self._process(args, log_prefix='export_banned_boards', env={'YT_TOKEN': yt_token})

    def _process(self, cmd_args, log_prefix, **kwargs):
        with sdk2.helpers.ProcessLog(self, logging.getLogger(log_prefix)) as pl:
            process = subprocess.Popen(
                cmd_args,
                stdout=pl.stdout,
                stderr=pl.stderr,
                **kwargs
            )
            process.wait()
            if process.returncode:
                raise Exception('Process was finished unsuccessfully')
