import requests
from sandbox import sdk2


class LaunchYasapPdbBackendTasks(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        is_beta_statface = sdk2.parameters.Bool(
            'Is beta statface', default=True,
        )
        base_url = sdk2.parameters.String(
            'Base url', default='',
        )
        report_name = sdk2.parameters.String(
            'Report name', default='',
        )

    @property
    def data(self):
        _data = {}
        _data['beta'] = self.Parameters.is_beta_statface
        _data['path'] = self.Parameters.report_name
        _data['username'] = sdk2.Vault.data('YASAP', 'statface_username')
        _data['password'] = sdk2.Vault.data('YASAP', 'statface_password')
        return _data

    @property
    def headers(self):
        _data = {}
        oauth_token = sdk2.Vault.data('YASAP', 'backend_oauth_token')
        _data['AUTHORIZATION'] = 'OAuth ' + oauth_token
        return _data

    def on_execute(self):
        """
            Launch PDB Backend tasks.
        """
        base_url = self.Parameters.base_url
        r = requests.post(
            base_url, json=self.data, headers=self.headers, verify=False,
        )
        r.raise_for_status()
