import logging
import requests

from sandbox import sdk2


class LaunchYasapPdbBackendComplaintsTasks(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        task = sdk2.parameters.String('Task name', default_value='')
        base_url = sdk2.parameters.String('Service url', default_value='')
        additional_params = sdk2.parameters.Dict('Additional params for task', default={})

    @property
    def params(self):
        _data = {}
        _data['task'] = self.Parameters.task
        return _data

    @property
    def data(self):
        _data = {}
        _data['additional_params'] = self.Parameters.additional_params or {}
        return _data

    @property
    def headers(self):
        _data = {}
        oauth_token = sdk2.Vault.data('YASAP', 'backend_oauth_token')
        _data['AUTHORIZATION'] = 'OAuth ' + oauth_token
        return _data

    def on_execute(self):
        """
            Launch PDB Backend Complaints tasks.
        """
        base_url = self.Parameters.base_url
        r = requests.post(base_url, json=self.data, headers=self.headers, params=self.params, verify=False)
        try:
            r.raise_for_status()
        except:
            logging.error(r.content)
            raise
