import yt.wrapper as yt
import argparse


def merge_mapper(row):
    yield row


def merge(yt_client, input_path, output_path):
    yt_client.run_map(merge_mapper, input_path, output_path)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--token-file', required=True, help='YT token file')
    parser.add_argument('--proxy', required=True, help='YT proxy')
    parser.add_argument('--input-path', required=True, nargs='+', help='Input tables path')
    parser.add_argument('--output-path', required=True, help='Output tables path')
    args = parser.parse_args()

    with open(args.token_file) as token_file:
        yt_token = token_file.read().strip()

    yt_client = yt.YtClient(
        proxy=args.proxy,
        token=yt_token,
        config={
            'pickling': {
                'python_binary': '/skynet/python/bin/python',
            }
        }
    )

    merge(yt_client, args.input_path, args.output_path)
