def calculate_config(config):
    fixes = config['fixes']
    result = {}

    for key, value in config['weights'].iteritems():
        result[key] = {}
        for subkey, subvalue in value.iteritems():
            result[key][subkey] = float(subvalue) * float(fixes[subkey]) if subkey in fixes else float(subvalue)

    return result


def calculate_issue_weight(issue, config):
    tags = [] if issue['tags'] is None else issue['tags']
    user_factor_tags = [] if issue['userFactor'] is None else issue['userFactor']

    max_env_coefficient = 1.0
    points = 100.0

    env = min(issue_weight_sum(tags, config['env']), max_env_coefficient)
    feature = issue_weight_first(tags, config['feature'])
    action = issue_weight_first(tags, config['action'])
    place = issue_weight_sum(tags, config['place'])
    mod = issue_weight_mult(tags, config['mod'])
    user_factor = issue_weight_sum(user_factor_tags, config['user_factor'])

    reach = points * feature * action * place * env
    impact = mod * user_factor

    return 0 if impact == 0 else max(1.0, round(impact * reach))


def calculate_issue_priority(weight, config):
    if 'blocker' in config and weight >= config['blocker']:
        return 'blocker'
    elif 'critical' in config and weight >= config['critical']:
        return 'critical'
    elif 'normal' in config and weight >= config['normal']:
        return 'normal'
    elif 'minor' in config and weight >= config['minor']:
        return 'minor'
    else:
        return 'trivial'


def issue_weight_mult(tags, weights):
    res = 1.0
    for tag in tags:
        if tag in weights:
            res *= weights[tag]

    return res


def issue_weight_sum(tags, weights):
    res = 0.0
    count = 0
    for tag in tags:
        if tag in weights:
            res += weights[tag]
            count += 1

    return res if count > 0 else 1.0


def issue_weight_first(tags, weights):
    for tag in tags:
        if tag in weights:
            return weights[tag]

    return 1.0
