# -*- coding: utf-8 -*-
import os

from sandbox import sdk2
from sandbox.common import errors
from sandbox.common.types.resource import State
from sandbox.projects.common.build import YaMake, parameters as build_parameters
from sandbox.projects.common.nanny import nanny

from sandbox.projects.collections import resources


class CollectionsBuildBackend(YaMake.YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Сборка бекенда Яндекс.Коллекций
    """
    type = 'COLLECTIONS_BUILD_BACKEND'

    resources = [
        resources.CollectionsBackendAdminApiServer,
        resources.CollectionsBackendApiServer,
        resources.CollectionsBackendCeleryWorker,
        resources.CollectionsBackendIpython,
    ]

    def get_context_override(self):
        return {
            build_parameters.CheckoutParameter.name: True,
        }

    def get_targets(self):
        return [
            resource.arcadia_build_path
            for resource in self.resources
        ]

    def get_arts(self):
        return [
            {
                'path': os.path.join(
                    resource.arcadia_build_path, resource.arcadia_build_name
                )
            } for resource in self.resources
        ]

    def get_resources(self):
        return {
            resource.arcadia_build_name: {
                'resource_type': resource,
                'description': resource.__doc__,
                'resource_path': resource.arcadia_build_name,
            } for resource in self.resources
        }

    def on_execute(self):
        YaMake.YaMakeTask.on_execute(self)
        config_resource = sdk2.Resource.find(
            type='WATSON_OFFER_PARSER_CONFIG',
            state=State.READY
        ).first()
        if not config_resource:
            raise errors.TaskFailure("Could not find binary")
        config_data = sdk2.ResourceData(config_resource)
        with open('offer_parser_config.json', 'wb') as result_file, open(str(config_data.path), 'rb') as config_file:
            result_file.write(config_file.read())
        self._create_resource(
            'Watson offer parser config #{}'.format(config_resource.id),
            'offer_parser_config.json',
            resources.CollectionsOfferParserConfig,
            complete=True
        )

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMake.YaMakeTask.on_release(self, additional_parameters)
