from sandbox.projects.common.backend_build_pipeline.GenerateExtServicesYasmPanelsBaseTask import GenerateExtServicesYasmPanelsBaseTask


class CollectionsBackendGenerateExtServicesYasmPanels(GenerateExtServicesYasmPanelsBaseTask):
    """
    Task for Collections backend ext services yasm panels generation
    """
    class FailPercentParams(GenerateExtServicesYasmPanelsBaseTask.FailPercentParams):
        SIGNAL_PREFIX = 'collections'

        @classmethod
        def default_fail_codes(cls):
            from pdb_yasm.ext_services import EXCEPTIONAL_CODES, FAIL, TIMEOUT_CODES
            return ['4xx', '5xx', FAIL] + list(EXCEPTIONAL_CODES) + list(TIMEOUT_CODES)

        @classmethod
        def all_codes(cls):
            from pdb_yasm.ext_services import EXCEPTIONAL_CODES, SUCCESS, FAIL, TIMEOUT_CODES
            return ['{}xx'.format(i) for i in range(1, 6)] + [SUCCESS, FAIL] + list(EXCEPTIONAL_CODES) + list(TIMEOUT_CODES)

    def _get_panel_template(self):
        from pdb_yasm.panels import get_ext_services_panel_template
        return get_ext_services_panel_template()

    def _get_ext_services(self):
        from pdb_yasm import ExtServicesNames
        return ExtServicesNames

    def _get_tags(self, ctype):
        return {
            'uwsgi': {
                'itype': ['pdbuwsgi'],
                'ctype': [ctype],
                'prj': ['pdb-backend', 'pdb-backend-upload'],
                'geo': ['sas', 'man', 'vla'],
            },
            'celery': {
                'itype': ['pdbworker'],
                'ctype': [ctype],
                'prj': ['pdb'],
                'geo': ['sas', 'man', 'vla'],
            }
        }

    def _get_ext_services_alerts_config(self, services):
        from pdb_yasm import ExtServicesNames
        from pdb_yasm.ext_services import EXCEPTIONAL_CODES, FAIL
        base_config = {
            service.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=2, crit=5),
                    'signal_kwargs': {
                        'fail_codes': self.FailPercentParams.default_fail_codes(),
                    }
                }
            }
            for service in services
        }
        config_patch = {
            ExtServicesNames.avatars.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=10, crit=15),
                    "value_modify": {
                        "type": "aver",
                        "window": 180
                    },
                }
            },
            ExtServicesNames.antispam.name: {
                self.FAIL_PERC_ALERT: {
                    'signal_kwargs': {
                        'fail_codes': ['4xx', '5xx', FAIL] + list(EXCEPTIONAL_CODES)  # want to separate timeouts
                    },
                }
            },
            ExtServicesNames.logbroker.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=10, crit=25),
                }
            },
            ExtServicesNames.market.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=10, crit=20),
                    'signal_kwargs': {
                        'fail_codes': ['4xx', '5xx', FAIL] + [code for code in EXCEPTIONAL_CODES if code != 404]  # 404 is ok
                    }
                }
            },
            ExtServicesNames.push.name: {
                self.FAIL_PERC_ALERT: {
                    'signal_kwargs': {
                        'fail_codes': ['4xx', '5xx', FAIL] + [code for code in EXCEPTIONAL_CODES if code != 404]  # 404 is ok when canceling
                    }
                }
            },
            ExtServicesNames.rca.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=146, crit=147),  # too unpredictable to monitor - force ok
                    'signal_kwargs': {
                        'fail_codes': [FAIL],
                    }
                }
            },
            ExtServicesNames.sprav.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=5, crit=10),
                    'signal_kwargs': {
                        'fail_codes': ['4xx', '5xx', FAIL] + [code for code in EXCEPTIONAL_CODES if code != 403]  # 403 is ok for has_user
                    }
                }
            },
            ExtServicesNames.videoparse.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=10, crit=15),
                    'signal_kwargs': {
                        'fail_codes': ['4xx', '5xx', FAIL] + list(EXCEPTIONAL_CODES)  # want to separate timeouts
                    },
                    "value_modify": {
                        "type": "aver",
                        "window": 180
                    },
                }
            },
            ExtServicesNames.xmlsearch.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=5, crit=10),
                }
            },
            ExtServicesNames.zen.name: {
                self.FAIL_PERC_ALERT: {
                    'signal_kwargs': {
                        'fail_codes': ['4xx', '5xx', FAIL] + [code for code in EXCEPTIONAL_CODES if code != 404]  # 404 is ok when there is no channel
                    }
                }
            },
            ExtServicesNames.zora.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=146, crit=147),  # too unpredictable to monitor - force ok
                    'signal_kwargs': {
                        'fail_codes': [FAIL],
                    }
                }
            },
        }
        return self.recursive_merge_dict(config_patch, base_config)


__TASK__ = CollectionsBackendGenerateExtServicesYasmPanels
