from sandbox import sdk2

from sandbox.common.types.misc import NotExists

from sandbox.projects import resource_types
from sandbox.projects.collections.basesearch import BoardsAnalyzeBasesearchPerformance as basesearch_task

import json


_COMPATIBLE_TASK_TYPES = [
    basesearch_task.BoardsAnalyzeBasesearchPerformance.type,
]


class BoardsCompareAnalyzePerformance(sdk2.Task):
    """
        Compare results of two performance tasks
    """

    class Parameters(sdk2.Task.Parameters):
        task1_id = sdk2.parameters.Task('Task 1', task_type=_COMPATIBLE_TASK_TYPES)
        task2_id = sdk2.parameters.Task('Task 2', task_type=_COMPATIBLE_TASK_TYPES)
        max_delta = sdk2.parameters.Float('Maximum possible delta', default=2)

    @property
    def footer(self):
        if self.Context.has_diff == NotExists or self.Context.deltas == NotExists:
            return {"Calculating": "&nbsp;"}

        deltas = self.Context.deltas
        return {"Delta1": deltas[0], "Delta2": deltas[1], "Has diff": self.Context.has_diff}

    def on_execute(self):
        deltas = [self.__get_delta(task) for task in (self.Parameters.task1_id, self.Parameters.task2_id)]
        self.Context.deltas = deltas
        self.Context.has_diff = abs(deltas[0] - deltas[1]) > self.Parameters.max_delta
        compare_result = resource_types.BASESEARCH_PERFORMANCE_COMPARE_RESULT(self, self.Parameters.description, "diff.txt")
        with open(str(sdk2.ResourceData(compare_result).path), "w") as result_file:
            result_file.write("Delta1: {}, Delta2: {}\n".format(deltas[0], deltas[1]))

    def __get_delta(self, task):
        return json.loads(task.Context.new_stats)["diff"]["shooting.rps_0.5"] if task is not None else 0.0
