import logging
from sandbox.sandboxsdk.channel import channel
import sandbox.common.types.client as ctc

from sandbox.projects.common.base_search_quality import node_types
from sandbox.projects.common.base_search_quality import response_diff_task
from sandbox.projects.common.base_search_quality.tree import htmldiff
from sandbox.projects.common.base_search_quality.response_saver import DefaultResponseSaverParams
from sandbox.projects.collections.basesearch import responses as boards_responses


class _GtaRelatedAttributeNode(node_types.GtaRelatedAttributeNode):
    def WriteDiff(self, diff_file, query_number, property_path, values1, values2, changed_props):
        try:
            property_name = property_path[-1]
            if property_name == '_AllFactors':
                factors1 = values1[0].split(";")
                factors2 = values2[0].split(";")
                node_types.write_objects_diff(diff_file, query_number, property_path + ["factors"],
                                              factors1, factors2, changed_props)
                return True
            else:
                return super(_GtaRelatedAttributeNode, self).WriteDiff(
                    diff_file, query_number, property_name,
                    values1, values1, changed_props
                )
        except Exception as e:
            logging.error("Failure during attribute parsing, rollback to simple comparison: {}".format(e))
            return super(_GtaRelatedAttributeNode, self).WriteDiff(
                diff_file, query_number, property_name,
                values1, values1, changed_props
            )


_GENERATION_TASK_TYPES = (
    'COLLECTIONS_BOARDS_GET_BASESEARCH_RESPONSES',
)


class BoardsCompareBasesearchResponses(response_diff_task.BaseCompareBasesearchResponses):

    type = 'COLLECTIONS_BOARDS_COMPARE_BASESEARCH_RESPONSES'

    required_ram = 100 << 10
    client_tags = ctc.Tag.LINUX_PRECISE

    def _find_queries(self, responses_resource):
        logging.info("Retrieving responses getting task, id=%s", responses_resource.task_id)
        task = channel.sandbox.get_task(responses_resource.task_id)
        if task.type not in _GENERATION_TASK_TYPES:
            logging.info("task {}.{} not in allowed _GENERATION_TASK_TYPES".format(responses_resource.task_id, task.type))
            return None
        return task.ctx[DefaultResponseSaverParams.QueriesParameter.name]

    def _get_custom_node_types(self):
        node_types = response_diff_task.BaseCompareBasesearchResponses._get_custom_node_types(self)
        node_types.update(htmldiff.node_types_dict([_GtaRelatedAttributeNode()]))
        return node_types

    def _get_response_patchers(self):
        patchers = response_diff_task.BaseCompareBasesearchResponses._get_response_patchers(self)
        patchers.extend(boards_responses.get_response_patchers())
        return patchers


__Task__ = BoardsCompareBasesearchResponses
