from sandbox.projects.collections.basesearch import responses as collections_responses
from sandbox.projects.collections.basesearch import task as collections_task


_OUT_RESOURCE_KEY = 'out_resource_id'
_STATS_KEY = 'stats'


class BoardsGetBasesearchResponses(collections_responses.ResponsesTask,
                                   collections_task.BaseBoardssearchTask):

    type = 'COLLECTIONS_BOARDS_GET_BASESEARCH_RESPONSES'
    required_ram = 10 << 10
    input_parameters = \
        collections_task.BaseBoardssearchTask.basesearch_input_parameters + \
        collections_responses.ResponsesTask.input_parameters

    def on_enqueue(self):
        collections_task.BaseBoardssearchTask.on_enqueue(self)
        self._create_responses_resource(_OUT_RESOURCE_KEY)

    def on_execute(self):
        collections_task.BaseBoardssearchTask.on_execute(self)
        basesearch = self._get_search()
        with basesearch:
            self._get_responses(basesearch, _OUT_RESOURCE_KEY, _STATS_KEY)


__Task__ = BoardsGetBasesearchResponses
