import logging

from sandbox.projects.common.search.settings import CollectionsSettings
import sandbox.projects.resource_types as common_resources

from sandbox import sdk2

import sandbox.common.types.task as ctt


class CollectionsBoardsLoadBasesearchDatabase(sdk2.Task):
    """
        Loads index shards to sandbox from nanny service instances directly
    """
    class Requirements(sdk2.Task.Requirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        nanny_service_name = sdk2.parameters.String("Nanny Service Name", description="Nanny Service With Basesearch", default="pdb_search_boards_base_priemka")
        pass

    def on_execute(self):
        logging.info("Run task DETACH_SERVICE_INDEX")

        detach_task_class = sdk2.Task["DETACH_SERVICE_INDEX"]
        with self.memoize_stage.create_children:
            task = detach_task_class(
                self, description=self.Parameters.description,
                service_name=self.Parameters.nanny_service_name
            )
            task.enqueue()

            self.Context.task_id = task.id
            raise sdk2.WaitTask(task, ctt.Status.Group.FINISH)

        detach_index_task_class = sdk2.Task["DETACH_RTYSERVER_INDEX"]

        task = self.find(id=self.Context.task_id).first()
        shard_prefix = CollectionsSettings().basesearch_database_prefix()
        for sub_task in task.find(task_type=detach_index_task_class):
            for db in sdk2.Resource.find(common_resources.RTYSERVER_SEARCH_DATABASE, task=sub_task).limit(1):
                index_timestamp = db.index_timestamp
                db.shard_instance = "{}-{}-{}".format(shard_prefix, sub_task.Context.shard_id_num, index_timestamp)
