import urllib2
import logging

from sandbox.sandboxsdk import parameters

from sandbox.projects import resource_types
from sandbox.projects.common import dolbilka
from sandbox.projects.common import profiling as search_profiling
from sandbox.projects.common.search import performance as search_performance
from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.tank.load_resources import resources as tank_resources
from sandbox.projects.collections.basesearch import task as basesearch_task


class PlanParameter(parameters.ResourceSelector):
    name = 'dolbilo_plan_resource_id'
    description = 'Plan'
    group = dolbilka.DOLBILKA_GROUP
    resource_type = resource_types.BASESEARCH_PLAN
    required = True


class BoardsTestBasesearchPerformance(search_performance.OldShootingTask,
                                      search_profiling.ProfilingTask,
                                      basesearch_task.BaseBoardssearchTask):
    """
        Benchmark for boardsrtyserver
    """

    type = 'COLLECTIONS_BOARDS_TEST_BASESEARCH_PERFORMANCE'

    client_tags = search_performance.OldShootingTask.client_tags & basesearch_task.BaseBoardssearchTask.client_tags

    input_parameters = \
        (PlanParameter,) + \
        basesearch_task.BaseBoardssearchTask.basesearch_input_parameters + \
        search_performance.OldShootingTask.shoot_input_parameters + \
        search_profiling.ProfilingTask.input_parameters

    def on_enqueue(self):
        basesearch_task.BaseBoardssearchTask.on_enqueue(self)
        self.execution_space = search_settings.CollectionsSettings.basesearch_executable_disk(self.ctx, basesearch_task.BASESEARCH_PARAMS.Database)
        self.required_ram = search_settings.ImagesSettings.basesearch_executable_memory(
            self.ctx,
            basesearch_task.BASESEARCH_PARAMS.Database
        ) + 5 * 1024

    def on_execute(self):
        basesearch_task.BaseBoardssearchTask.on_execute(self)

        basesearch = self._get_search()

        self._init_virtualenv(tank_resource_type=tank_resources.YANDEX_TANK_VIRTUALENV_19)
        self._profiling_init(basesearch, self.__get_perf_data_path())
        with basesearch:
            self._old_shoot(basesearch, self.ctx[PlanParameter.name])
            # Dump tass statistics for further analysis (experimental)
            try:
                tass_data = urllib2.urlopen("http://localhost:{}/tass".format(basesearch.port)).read()
                with open("tass.txt", "w") as f:
                    f.write(tass_data)
                self.create_resource(self.descr + ", tass", "tass.txt", resource_types.OTHER_RESOURCE)
            except Exception as e:
                logging.info("Failed to read tass stats: {}".format(e))

        self._profiling_report(basesearch, self.__get_perf_data_path())

    def _get_queries_parameter(self):
        return PlanParameter

    def get_short_task_result(self):
        if not self.is_completed():
            return None

        if "max_rps" in self.ctx:
            return "{:0.2f}".format(self.ctx["max_rps"])

    def __get_perf_data_path(self, recreate=False):
        return self.abs_path("perf.data")


__Task__ = BoardsTestBasesearchPerformance
