from sandbox.projects.common.search import settings as search_settings
from sandbox.projects.common.search.basesearch import task as search_task
from sandbox.projects.collections.basesearch import components as collections_basesearch_components


BASESEARCH_PARAMS = collections_basesearch_components.create_boards_search_params()


class BaseBoardssearchTask(search_task.BasesearchComponentTask):

    required_ram = 10 * 1024
    execution_space = 10 * 1024

    basesearch_input_parameters = \
        BASESEARCH_PARAMS.params + \
        search_task.BasesearchComponentTask.basesearch_input_parameters

    def on_execute(self):
        search_task.BasesearchComponentTask.on_execute(self)

    def on_enqueue(self):
        search_task.BasesearchComponentTask.on_enqueue(self)
        search_settings.CollectionsSettings.ensure_search_database(
            self,
            self._get_queries_parameter(),
            BASESEARCH_PARAMS.Database
        )

    def _component(self, params, *args, **kwargs):
        return collections_basesearch_components.get_boards_search(params=params, *args, **kwargs)

    def _get_search(self, params=BASESEARCH_PARAMS, **kwargs):
        component = self._component(params, **kwargs)
        self.init_search_component(component)
        return component

    def _get_queries_parameter(self):
        raise NotImplementedError()
