from sandbox import sdk2

from sandbox.projects.collections.recommender_base.ModelsAutoDeploy import ModelsAutoDeployBase

from sandbox.projects.collections.board_recommender.resources import CollectionsBoardRecommenderBundle
from sandbox.projects.collections.board_recommender.resources import CollectionsBoardRecommenderDataArchive


class DeployCollectionsBoardRecommender(ModelsAutoDeployBase):
    """
        Task for board recommender deployment
    """

    class Parameters(ModelsAutoDeployBase.DefaultParameters):
        models_resource = sdk2.parameters.Resource(
            "Board recommender data archive",
            resource_type=CollectionsBoardRecommenderDataArchive,
            required=True
        )

    def test_bundle(self):
        self.Context.test_task_id = None
        self.Context.save()

    NANNY_PARAMS = {
        'deployment_nanny_dashboard_name': 'pdb_recommender_boards',
        'deployment_nanny_dashboard_recipe': 'deploy_prod_noconfirm',
        'deployment_nanny_dashboard_filter': 'prod'
    }

    bundle_resource_type = CollectionsBoardRecommenderBundle
    resource_type_str = str(bundle_resource_type)
    nanny_semaphore_name = 'DEPLOY_COLLECTIONS_BOARD_RECOMMENDER'
