from sandbox import sdk2

from sandbox.projects.collections.card_recommender.components import CardRecommender
from sandbox.projects.collections.recommender_base.GeneralTest import GeneralTestBase
from sandbox.projects.collections.resources import CollectionsCardRecommenderBundle, CollectionsCardRecommenderShard


class CardRecommenderGeneralTest(GeneralTestBase):
    """ Task for testing base Card Recommender functionality """

    class Requirements(GeneralTestBase.DefaultRequirements):
        ram = 110 * 1024
        disk_space = 110 * 1024

    class Parameters(GeneralTestBase.DefaultParameters):
        bundle_resource = sdk2.parameters.Resource(
            "Resource with Card Recommender bundle",
            resource_type=CollectionsCardRecommenderBundle,
            required=True
        )
        shard_resource = sdk2.parameters.Resource(
            "Resource with Card Recommender shard",
            resource_type=CollectionsCardRecommenderShard,
            required=True
        )

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)
        shard_resource_data = sdk2.ResourceData(self.Parameters.shard_resource)

        self.__execute__(CardRecommender(self,
                                           str(bundle_resource_data.path),
                                           str(shard_resource_data.path),
                                           self.Parameters.port))
