from sandbox import sdk2

from sandbox.projects.collections.card_recommender.components import CardRecommender
from sandbox.projects.collections.recommender_base.GetResponses import GetResponsesBase
from sandbox.projects.collections.resources import CollectionsCardRecommenderBundle, CollectionsCardRecommenderShard, CollectionsCardRecommenderResponses

class CardRecommenderGetResponses(GetResponsesBase):
    """ Task for fetching Card Recommender responses """

    class Requirements(GetResponsesBase.DefaultRequirements):
        ram = 80 * 1024
        disk_space = 100 * 1024

    class Parameters(GetResponsesBase.DefaultParameters):
        bundle_resource = sdk2.parameters.Resource(
            "Resource with Card Recommender bundle",
            resource_type=CollectionsCardRecommenderBundle,
            required=True
        )
        shard_resource = sdk2.parameters.Resource(
            "Resource with Card Recommender shard",
            resource_type=CollectionsCardRecommenderShard,
            required=True
        )

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)
        shard_resource_data = sdk2.ResourceData(self.Parameters.shard_resource)

        card_recommender = CardRecommender(self,
                                           str(bundle_resource_data.path),
                                           str(shard_resource_data.path),
                                           self.Parameters.port)

        responses_resource = CollectionsCardRecommenderResponses(self, "Card recommender responses", "responses.txt")
        responses_resource_data = sdk2.ResourceData(responses_resource)

        self.__execute__(card_recommender, responses_resource_data)
