from sandbox import sdk2

from sandbox.projects.collections.recommender_base.ModelsAutoDeploy import ModelsAutoDeployBase

from sandbox.projects.collections.card_recommender import CardRecommenderGeneralTest
from sandbox.projects.collections.resources import CollectionsCardRecommenderBundle
from sandbox.projects.collections.resources import CollectionsCardRecommenderModelsArchive
from sandbox.projects.collections.resources import CollectionsCardRecommenderShard


class CardRecommenderModelsAutoDeploy(ModelsAutoDeployBase):
    """ Task for building card recommender production bundle with given models archive"""

    class Parameters(ModelsAutoDeployBase.DefaultParameters):
        models_resource = sdk2.parameters.Resource(
            "Resource with card recommender models",
            resource_type=CollectionsCardRecommenderModelsArchive,
            required=True
        )
        shard_resource = sdk2.parameters.Resource(
            "Resource with Card Recommender shard",
            resource_type=CollectionsCardRecommenderShard,
            required=True
        )

    def test_bundle(self):
        self.__test_bundle__(
            CardRecommenderGeneralTest.CardRecommenderGeneralTest(
                self,
                bundle_resource=self.find_new_bundle_resource(),
                dolbilka_plan_resource=self.find_plan_resource(),
                shard_resource=self.Parameters.shard_resource
            ))

    NANNY_PARAMS = {
        'deployment_nanny_dashboard_name': 'pdb_production',
        'deployment_nanny_dashboard_recipe': 'deploy_collections_card_recommender',
        'deployment_nanny_dashboard_filter': 'card_recommender'
    }

    bundle_resource_type = CollectionsCardRecommenderBundle
    resource_type_str = str(bundle_resource_type)
    nanny_semaphore_name = 'COLLECTIONS_CARD_RECOMMENDER_DEPLOY'
