from sandbox.projects.collections.daemons import task as daemons_task


class CollectionsGetInformersDaemonResponses(daemons_task.BaseGetResponsesTask, daemons_task.BaseInformersDaemonTask):
    """
        Get informers responses from local instance
    """

    type = 'COLLECTIONS_GET_INFORMERS_DAEMON_RESPONSES'

    allowed_response_http_codes = [200]

    input_parameters = \
        daemons_task.BaseGetResponsesTask.input_parameters + \
        daemons_task.BaseInformersDaemonTask.input_parameters

    def on_enqueue(self):
        daemons_task.BaseGetResponsesTask.on_enqueue(self)
        daemons_task.BaseInformersDaemonTask.on_enqueue(self)

    def _get_daemon(self):
        return daemons_task.BaseInformersDaemonTask._get_daemon(self)

    def _get_queries_parameter(self):
        return daemons_task.QueriesParameter


__Task__ = CollectionsGetInformersDaemonResponses
