from sandbox import sdk2

from sandbox.projects.collections.resources import CollectionsFeedBlenderResponses
from sandbox.projects.collections.resources import CollectionsFeedBlenderResponsesAnalysis

import json


class FeedBlenderAnalyzeResponses(sdk2.Task):
    """ Task for analyzing Feed Blender responses """

    class Parameters(sdk2.Task.Parameters):
        responses_resource = sdk2.parameters.Resource(
            "Resource with Feed Blender responses",
            resource_type=CollectionsFeedBlenderResponses,
            required=True
        )

    def load_responses(self, file_path):
        with open(file_path, 'r') as f:
            raw_responses = f.readlines()
            return [json.loads(r.strip()) for r in raw_responses]

    def check_response(self, response):
        items = response["items"]

        if len(items) == 0:
            return "Empty blender response"

        return None

    def analyze_responses(self, responses):
        result = []

        for i in range(0, len(responses)):
            response_error = self.check_response(responses[i])
            if response_error is not None:
                result.append("Error in response number {}. {}".format(i, response_error))

        return result

    def on_execute(self):
        responses_resource_data = sdk2.ResourceData(self.Parameters.responses_resource)
        responses = self.load_responses(str(responses_resource_data.path))

        result = self.analyze_responses(responses)

        if len(result) > 0:
            analysis_resource = CollectionsFeedBlenderResponsesAnalysis(
                self,
                "Feed blender responses analysis",
                "responses_analysis.txt"
            )
            analysis_resource_data = sdk2.ResourceData(analysis_resource)
            with open(str(analysis_resource_data.path), 'w') as analysis_file:
                analysis_file.write(json.dumps(result))
            analysis_resource_data.ready()
            raise RuntimeError("There are some errors in feed blender responses. See analysis results.")
