from sandbox import sdk2

from sandbox.projects.collections.feed_blender.components import FeedBlender
from sandbox.projects.collections.recommender_base.GeneralTest import GeneralTestBase
from sandbox.projects.collections.resources import CollectionsFeedBlenderBundle


class FeedBlenderGeneralTest(GeneralTestBase):
    """ Task for testing base Feed Blender functionality """

    class Requirements(GeneralTestBase.DefaultRequirements):
        pass

    class Parameters(GeneralTestBase.DefaultParameters):
        bundle_resource = sdk2.parameters.Resource(
            "Resource with Feed Blender bundle",
            resource_type=CollectionsFeedBlenderBundle,
            required=True
        )

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)
        self.__execute__(FeedBlender(self, str(bundle_resource_data.path), self.Parameters.port))
