from sandbox import sdk2

from sandbox.projects.collections.feed_blender.components import FeedBlender
from sandbox.projects.collections.recommender_base.PerfTest import PerfTestBase
from sandbox.projects.collections.resources import CollectionsFeedBlenderBundle

class FeedBlenderPerfTest(PerfTestBase):
    """ Task for testing base Feed Blender performance """

    class Parameters(PerfTestBase.DefaultParameters):
        bundle_resource = sdk2.parameters.Resource(
            "Resource with Feed Blender bundle",
            resource_type=CollectionsFeedBlenderBundle,
            required=True
        )

    class Requirements(PerfTestBase.DefaultRequirements):
        pass


    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)

        self.__execute__(FeedBlender(self, str(bundle_resource_data.path), self.Parameters.port))
