import argparse
import base64
import json
import logging
import os
import random
import yt.wrapper as yt


def remove_exp(request):
    exp_name_key = 'exp_name='
    exp_start_pos = request.find(exp_name_key)
    if exp_start_pos == -1:
        return request

    exp_end_pos = request.find('&', exp_start_pos + len(exp_name_key))
    if exp_end_pos == -1:
        exp_end_pos = len(request)
    else:
        exp_end_pos += 1

    return request[:exp_start_pos] + request[exp_end_pos:]


def mapper(row):
    new_row = {
        'data': row['PostBody'],
        'request': row['HttpPath'] + '?' + row['CgiParams'],
        'random': random.random()
    }
    yield yt.create_table_switch(0)
    yield new_row

    yield yt.create_table_switch(1)
    new_row['request'] = remove_exp(new_row['request'])
    new_row['random'] = random.random()
    yield new_row


def prepare_request(row):
    unpacked_data = base64.b64decode(row['data']) if row['data'] is not None else ''

    request = 'POST {} HTTP/1.0\r\n'.format(row['request'])
    request += 'Content-Length: {}\r\n'.format(len(unpacked_data))
    request += 'User-Agent: Yandex.Tank (sandbox)\r\n\r\n'
    request += unpacked_data

    return '{}\n{}\r\n'.format(len(request), request)


def create_requests_file(table, file_path, count):
    progress = 0
    requests_content = ''
    for row in yt.read_table(table):
        requests_content += prepare_request(row)
        progress += 1
        if progress % 100 == 0:
            logging.info(progress)
        if progress == count:
            break

    with open(file_path, 'w') as f:
        f.write(requests_content)


def create_file(table, configs, name, count):
    for config in configs["plan_configs"]:
        if config["name"] == name:
            create_requests_file(table, config["file_path"], count)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_table', dest='input_table', required=True)
    parser.add_argument('--server', dest='yt_server', required=True)
    parser.add_argument('--pool', dest='yt_pool', required=True)
    parser.add_argument('--requests_configs', dest='requests_configs', required=True)
    args = parser.parse_args()

    args.requests_configs = json.loads(args.requests_configs)
    count = int(args.requests_configs["global_count"])

    yt.config.set_proxy(args.yt_server)
    yt.config.token = os.environ.get('YT_TOKEN')
    yt.config['pickling']['force_using_py_instead_of_pyc'] = True
    yt.config["pickling"]["ignore_yson_bindings_for_incompatible_platforms"] = False
    yt.config['pickling']['python_binary'] = '/skynet/python/bin/python'

    logging.info('Start preparing requests.')

    with yt.TempTable() as all_requests_table, yt.TempTable() as clean_requests_table:
        yt.run_map(mapper, args.input_table, [all_requests_table, clean_requests_table])

        yt.run_sort(all_requests_table, all_requests_table, sort_by=['random'])
        yt.run_sort(clean_requests_table, clean_requests_table, sort_by=['random'])

        create_file(all_requests_table, args.requests_configs, "general", count)
        create_file(clean_requests_table, args.requests_configs, "perf", count)

    logging.info('Finish preparing requests')


if __name__ == '__main__':
    main()
