from sandbox import sdk2

from sandbox.projects.collections.feed_blender.components import FeedBlender
from sandbox.projects.collections.recommender_base.GetResponses import GetResponsesBase
from sandbox.projects.collections.resources import CollectionsFeedBlenderBundle, CollectionsFeedBlenderResponses


class FeedBlenderGetResponses(GetResponsesBase):
    """ Task for fetching Feed Blender responses """

    class Requirements(GetResponsesBase.DefaultRequirements):
        pass

    class Parameters(GetResponsesBase.DefaultParameters):
        bundle_resource = sdk2.parameters.Resource(
            "Resource with Feed Blender bundle",
            resource_type=CollectionsFeedBlenderBundle,
            required=True
        )

    def on_execute(self):
        bundle_resource_data = sdk2.ResourceData(self.Parameters.bundle_resource)

        feed_blender = FeedBlender(self, str(bundle_resource_data.path), self.Parameters.port)

        responses_resource = CollectionsFeedBlenderResponses(self, "Feed blender responses", "responses.txt")
        responses_resource_data = sdk2.ResourceData(responses_resource)

        self.__execute__(feed_blender, responses_resource_data)
