from sandbox import sdk2

from sandbox.projects.collections.recommender_base.ModelsAutoDeploy import ModelsAutoDeployBase

from sandbox.projects.collections.feed_blender import FeedBlenderGeneralTest
from sandbox.projects.collections.resources import CollectionsFeedBlenderBundle
from sandbox.projects.collections.resources import CollectionsFeedBlenderModelsArchive


class FeedBlenderModelsAutoDeploy(ModelsAutoDeployBase):
    """ Task for building blender production bundle with given models archive"""

    class Parameters(ModelsAutoDeployBase.DefaultParameters):
        models_resource = sdk2.parameters.Resource(
            "Resource with Feed Blender models",
            resource_type=CollectionsFeedBlenderModelsArchive,
            required=True
        )

    def test_bundle(self):
        self.__test_bundle__(
            FeedBlenderGeneralTest.FeedBlenderGeneralTest(
                self,
                bundle_resource=self.find_new_bundle_resource(),
                dolbilka_plan_resource=self.find_plan_resource()
            ))


    NANNY_PARAMS = {
        'deployment_nanny_dashboard_name': 'pdb_production',
        'deployment_nanny_dashboard_recipe': 'deploy_collections_feed_blender',
        'deployment_nanny_dashboard_filter': 'feed_blender'
    }

    bundle_resource_type = CollectionsFeedBlenderBundle
    resource_type_str = str(bundle_resource_type)
    nanny_semaphore_name = 'COLLECTIONS_FEED_BLENDER_DEPLOY'
