from sandbox import sdk2
from sandbox.sandboxsdk.network import is_port_free

from sandbox.sdk2.helpers import subprocess as sp

import tarfile
import time


class FeedBlender:
    def __init__(self, task, bundle_path, port):
        with tarfile.open(bundle_path, "r:gz") as tar:
            tar.extractall()
        with tarfile.open("./models.tar.gz", "r:gz") as tar:
            tar.extractall()

        self.process_log = sdk2.helpers.ProcessLog(task, logger="feed_blender.log")
        self.process = sp.Popen(
            [
                "./feed_blender",
                "--config", self.hack_config("./config.pbtxt"),
                "--port", str(port),
            ],
            stdout=self.process_log.stdout, stderr=sp.STDOUT,
        )
        while is_port_free(port):
            time.sleep(1)
            if self.process.poll() is not None:
                raise RuntimeError("Error in Feed Blender starting")

    def hack_config(self, config_path):
        with open(config_path, 'r') as f:
            config_str = f.read().replace('./', '')
            out_path = './config.txt'
            with open(out_path, 'w') as out:
                out.write(config_str)
                return out_path

    def close(self):
        self.process.terminate()
