# -*- coding: utf-8 -*-
import os
from sandbox.projects.collections import resources
from sandbox.projects.common.build import YaMake, parameters as build_parameters
from sandbox.projects.common.nanny import nanny


class BuildFeedReader(YaMake.YaMakeTask, nanny.ReleaseToNannyTask):
    """
        Build collections feed reader binary
    """
    type = 'BUILD_COLLECTIONS_FEED_READER'

    execution_space = 100 * 1024

    input_parameters = [
        build_parameters.ArcadiaUrl,
        build_parameters.BuildSystem,
        build_parameters.BuildType,
        build_parameters.ClearBuild
    ]

    resources = [
        resources.CollectionsFeedReader
    ]

    def get_context_override(self):
        return {
            build_parameters.CheckoutParameter.name: True
        }

    def get_targets(self):
        return [
            resource.arcadia_build_path
            for resource in self.resources
        ]

    def get_arts(self):
        return [
            {
                'path': os.path.join(
                    resource.arcadia_build_path, resource.arcadia_build_name
                )
            } for resource in self.resources
        ]

    def get_resources(self):
        return {
            resource.arcadia_build_name: {
                'resource_type': resource,
                'description': resource.__doc__,
                'resource_path': resource.arcadia_build_name,
            } for resource in self.resources
        }

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaMake.YaMakeTask.on_release(self, additional_parameters)
