# coding: utf-8

from sandbox import sdk2
from sandbox import common
from sandbox.projects.common.nanny import nanny
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinReporter
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinReportItems
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinTopItems

import os


class CollectionsFeedReaderBuildPumpkinItemShards(nanny.ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        cluster = sdk2.parameters.String("YT proxy", required=True, default="hahn")
        yt_token_vault = sdk2.parameters.String("YT token vault", required=True)
        state = sdk2.parameters.String("YT directory for index building state", required=True)
        build_reporter_task_id = sdk2.parameters.Integer("Build pumpkin reporter task", required=True)
        config_resource = sdk2.parameters.Resource("Reporter config", required=True)

    def on_execute(self):
        reporter_resource = CollectionsFeedReaderPumpkinReporter.find(
            task_id=self.Parameters.build_reporter_task_id
        ).first()
        reporter_path = str(sdk2.ResourceData(reporter_resource).path)

        report_items_file = "report_items"
        top_items_file = "top_items"
        config_path = str(sdk2.ResourceData(self.Parameters.config_resource).path)

        env = os.environ.copy()
        env["YT_TOKEN"] = sdk2.Vault.data(self.Parameters.yt_token_vault)

        with sdk2.helpers.ProcessLog(self, logger="reporter_log") as pl:
            ret_code = sp.Popen(
                [
                    reporter_path,
                    "--server", self.Parameters.cluster,
                    "--state", self.Parameters.state,
                    "--config", config_path,
                    "--report", report_items_file,
                    "--top", top_items_file,
                ],
                stdout=pl.stdout, stderr=sp.STDOUT, env=env
            ).wait()
            if ret_code != 0:
                raise common.errors.TaskFailure('Reporter run failed')

        sdk2.ResourceData(CollectionsFeedReaderPumpkinReportItems(self, self.Parameters.description, report_items_file))
        sdk2.ResourceData(CollectionsFeedReaderPumpkinTopItems(self, self.Parameters.description, top_items_file))

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
