# coding: utf-8

from sandbox import sdk2
from sandbox import common
from sandbox.projects.common.nanny import nanny

from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinReportItems
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinShard
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinTopItems
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinUserItemMapping
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinUserMapping

import tarfile


def find_resource(task_id, resource_type):
    resource = resource_type.find(task_id=task_id).first()
    if resource is None:
        raise common.errors.TaskFailure("Can't find resource " + resource_type.name)
    return resource


class CollectionsFeedReaderBuildPumpkinShard(nanny.ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        build_user_mapping_task_id = sdk2.parameters.Integer(
            'Build user mapping task', required=True)
        build_user_item_mapping_task_id = sdk2.parameters.Integer(
            'Build user-item mapping task', required=True)
        build_item_shards_task_id = sdk2.parameters.Integer(
            'Build item shards task', required=True)

    def on_execute(self):
        user_item_mapping = str(sdk2.ResourceData(find_resource(
            self.Parameters.build_user_item_mapping_task_id,
            CollectionsFeedReaderPumpkinUserItemMapping
        )).path)

        user_mapping = str(sdk2.ResourceData(find_resource(
            self.Parameters.build_user_mapping_task_id,
            CollectionsFeedReaderPumpkinUserMapping
        )).path)

        report_items = str(sdk2.ResourceData(find_resource(
            self.Parameters.build_item_shards_task_id,
            CollectionsFeedReaderPumpkinReportItems
        )).path)

        top_items = str(sdk2.ResourceData(find_resource(
            self.Parameters.build_item_shards_task_id,
            CollectionsFeedReaderPumpkinTopItems
        )).path)

        shard_resource = CollectionsFeedReaderPumpkinShard(self, self.Parameters.description, "pumpkin_shard.tar.gz")
        shard_resource_data = sdk2.ResourceData(shard_resource)

        def chmod(tarinfo):
            tarinfo.mode = tarinfo.mode | 0o644
            return tarinfo

        tar = tarfile.open(str(shard_resource_data.path), 'w:gz')
        tar.add(user_item_mapping, arcname="user_item_mapping", filter=chmod)
        tar.add(user_mapping, arcname="user_mapping_trie", filter=chmod)
        tar.add(report_items, arcname="report_items", filter=chmod)
        tar.add(top_items, arcname="top_items", filter=chmod)
        tar.close()

        shard_resource_data.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
