# coding: utf-8

from sandbox import sdk2
from sandbox import common
from sandbox.projects.common.nanny import nanny
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinOverlapper
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinUserMapping
from sandbox.projects.collections.resources import CollectionsFeedReaderPumpkinUserItemMapping

import os


def find_resource(task_id, resource_type):
    resource = resource_type.find(task_id=task_id).first()
    if resource is None:
        raise common.errors.TaskFailure("Can't find resource " + resource_type.name)
    return resource


class CollectionsFeedReaderBuildPumpkinUserMapping(nanny.ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        cluster = sdk2.parameters.String("YT proxy", required=True, default="hahn")
        yt_token_vault = sdk2.parameters.String("YT token vault", required=True)
        state = sdk2.parameters.String("YT directory for index building state", required=True)
        build_overlapper_task_id = sdk2.parameters.Integer("Build pumpkin overlapper task", required=True)
        build_user_item_mapping_task_id = sdk2.parameters.Integer("Build recommender shard task", required=True)

    def on_execute(self):
        overlapper_resource = find_resource(
            self.Parameters.build_overlapper_task_id,
            CollectionsFeedReaderPumpkinOverlapper
        )
        overlapper_path = str(sdk2.ResourceData(overlapper_resource).path)

        user_item_mapping_resource = find_resource(
            self.Parameters.build_user_item_mapping_task_id,
            CollectionsFeedReaderPumpkinUserItemMapping
        )
        user_item_mapping_path = str(sdk2.ResourceData(user_item_mapping_resource).path)

        output_file = "user_mapping_trie"

        env = os.environ.copy()
        env["YT_TOKEN"] = sdk2.Vault.data(self.Parameters.yt_token_vault)

        with sdk2.helpers.ProcessLog(self, logger="overlapper_log") as pl:
            ret_code = sp.Popen(
                [
                    overlapper_path,
                    "--server", self.Parameters.cluster,
                    "--state", self.Parameters.state,
                    "--shard", user_item_mapping_path,
                    "--trie", output_file,
                ],
                stdout=pl.stdout, stderr=sp.STDOUT, env=env
            ).wait()
            if ret_code != 0:
                raise common.errors.TaskFailure("Run failed")

        sdk2.ResourceData(
            CollectionsFeedReaderPumpkinUserMapping(self, self.Parameters.description, output_file)
        ).ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
